/* ***************************************************************************************
* FILE:          TouchInput.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TouchInput.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef TOUCHINPUT_H
#define TOUCHINPUT_H

namespace Courier {
class FrameworkWidget;
class ViewScene2D;
class ViewScene3D;
struct TouchInfo;
}


namespace Candera {
class Surface;
class Camera2D;
}


namespace hmibase {
namespace widget {
class Widget;
}


namespace input {
bool EqualsSurfaceId(const Candera::Surface* surface, ::FeatStd::SizeType surfaceId);
Courier::FrameworkWidget* ScreenIdFilteredGetTouchedWidget2D(Courier::ViewScene2D* view2D, const Courier::TouchInfo& info);
Courier::FrameworkWidget* ScreenIdFilteredGetTouchedWidget3D(Courier::ViewScene3D* view3D, const Courier::TouchInfo& info);
bool isInsideBoundingBox2D(hmibase::widget::Widget* widget, const Courier::TouchInfo& msg);

// Checks if the specified camera should be used in the beginning of the touch session for checking if the touch coordinates are inside the bounding rectangle of a widget's node
bool ShouldUseCameraForTouch(const Candera::Camera2D* camera);

// Configures the specified camera to be used in the beginning of the touch session for checking if the touch coordinates are inside the bounding rectangle of a widget's node
void SetUseCameraForTouch(Candera::Camera2D* camera, bool value);
}


}


#endif // TOUCHINPUT_H
