/* ***************************************************************************************
* FILE:          SceneMapping.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneMapping.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_SceneMapping_H)
#define _SceneMapping_H

namespace hmibase {
   namespace view {
      struct SceneMapping
      {
         Courier::ViewId           _nameID;
         Courier::View*            _scene;
         Courier::ViewController* (*_fktCreateInstance)();
         bool                      _is3DScene;
         unsigned int              _profileID;
         Courier::ViewId           _baseviewnameID;

         static Courier::View* createView(const Courier::Char* sViewName, SceneMapping* pScenes, unsigned cnt, Courier::IViewHandler* viewHandler);
         static bool           destroyView(SceneMapping* pScenes, unsigned cnt, const Courier::View* view);
         static Courier::ViewController* createViewController(const Courier::Char* sViewName, const SceneMapping* pScenes, unsigned cnt);

         static SceneMapping* base;
         static unsigned int baseCnt;

         const Courier::ViewId& ViewIdForHash(Courier::UInt32 hash) const; // To get viewId from Hash value
         Courier::View* ViewForId(const Courier::ViewId& id) const;
      };


#define SCENE_MAPPING_BEGIN(_aScenes) static struct ::hmibase::view::SceneMapping _aScenes[] = {

#ifdef USE_SPELLER_RENDERING
#define SCENE_MAPPING_ENTRY(_classtype_, __viewtype__)        {_classtype_::_name, COURIER_NEW(RenderTargetInvalidatingViewScene<Courier::__viewtype__>)(), _classtype_::createInstance}
#else
#define SCENE_MAPPING_ENTRY_TRANSITION(_width_, _height_, _cameradistance_)   
#define SCENE_MAPPING_ENTRY(_classtype_, __viewtype__)             {Courier::ViewId(_classtype_::_name), NULL, _classtype_::createInstance}
#define SCENE_MAPPING_ENTRY_2D(_classtype_)                        {Courier::ViewId(_classtype_::_name), NULL, _classtype_::createInstance, false, 0           ,Courier::ViewId(_classtype_::_name) }
#define SCENE_MAPPING_ENTRY_3D(_classtype_)                        {Courier::ViewId(_classtype_::_name), NULL, _classtype_::createInstance, true , 0           ,Courier::ViewId(_classtype_::_name) }
#define SCENE_MAPPING_ENTRY_EXTENDED_2D(_classtype_, _profileid_)  {Courier::ViewId(_classtype_::_name), NULL, _classtype_::createInstance, false, _profileid_ ,Courier::ViewId(_classtype_::_basename)}
#define SCENE_MAPPING_ENTRY_EXTENDED_3D(_classtype_, _profileid_)  {Courier::ViewId(_classtype_::_name), NULL, _classtype_::createInstance, true , _profileid_ ,Courier::ViewId(_classtype_::_basename)}
#endif

#define SCENE_MAPPING_END()        {Courier::ViewId(), NULL, 0, false, 0,Courier::ViewId() }};
   }
}
HMIBASE_DEPRECATED_TYPE_ALIAS(SceneMapping, ::hmibase::view::SceneMapping);
#endif // _SceneMapping_H
