/* ***************************************************************************************
* FILE:          SCHostUtils.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SCHostUtils is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_SCHOST_UTILS__
#define __HMIBASE_SCHOST_UTILS__

namespace Candera {
class Scene2DContext;
class AssetProvider;
}


namespace hmibase {
namespace view {
namespace util {


/************************************************************************/
class SCHostUtils
{
#ifdef WIN32
      /************************************************************************/
      /* SCHost and WinSim */
      /************************************************************************/

      friend class SCHostInitializer;
   public:
      /* Returns true if SCHost is loaded, this means we are running in SceneComposer or AssetTool. */
      static bool IsSCHostLoaded();

      /* Returns the composite context. */
      static Candera::Scene2DContext* GetComposite2DContext(Candera::AssetProvider& assetProvider, const FeatStd::Char* sceneName);

   private:
      static void SetSCHostLoaded(bool loaded);

#else
      /************************************************************************/
      /* Target application and LSim */
      /************************************************************************/
   public:
      static inline bool IsSCHostLoaded()
      {
         return false;
      }
#endif

   private:
      SCHostUtils();
};


}
}


}

#endif
