/* ***************************************************************************************
* FILE:          SCHostUtils.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SCHostUtils is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"
#include "SCHostUtils.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include <trcGenProj/Header/SCHostUtils.cpp.trc.h>
#endif

namespace hmibase {
namespace view {
namespace util {

#ifdef WIN32

/************************************************************************/
static bool& _isSCHostLoaded()
{
   static bool _loaded = false;
   return _loaded;
}


/************************************************************************/
bool SCHostUtils::IsSCHostLoaded()
{
   return _isSCHostLoaded();
}


/************************************************************************/
void SCHostUtils::SetSCHostLoaded(bool loaded)
{
   _isSCHostLoaded() = loaded;
}


/************************************************************************/
Candera::Scene2DContext* SCHostUtils::GetComposite2DContext(Candera::AssetProvider& assetProvider, const FeatStd::Char* sceneName)
{
   //this is required in order to have extension widgets working while editing the composites in SceneComposer, without it you will not see the button images
   //sesa removes the method in every new CGI Studio version without providing an alternative so we have to request it back
   return assetProvider.GetComposite2D(sceneName);
}


#endif
}


}
}
