/* ***************************************************************************************
* FILE:          RendererStatisticsOverlayWrapper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RendererStatisticsOverlayWrapper.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(RendererStatisticsOverlayWrapper_h)
#define RendererStatisticsOverlayWrapper_h

#include <Candera/Engine3D/Core/RendererStatisticsOverlay.h>
#include <FeatStd/Event/EventListener.h>


namespace hmibase {
namespace view {

struct RendererStatisticsOverlayWrapper
{
public:
    RendererStatisticsOverlayWrapper();
    void Init();

    bool mIsOverlayEnabled;
    Candera::RendererStatisticsOverlay*  mRendererStatisticsOverlay;
private:
    ///
    FeatStd::EventListener* mRenderTargetEventListener;
};

}
}

#endif