/* ***************************************************************************************
* FILE:          MemoryMappedAssetRepository.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MemoryMappedAssetRepository.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(MemoryMappedAssetRepository_h)
#define MemoryMappedAssetRepository_h

#include <sys/types.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetRepository.h>

#include "Courier/Version.h"

#include "AppUtils/HmiMacros.h"

namespace Candera {

class MemoryMappedAssetRepository : public AssetRepository
{
   public:
      explicit MemoryMappedAssetRepository(const Char* fileName);
      virtual ~MemoryMappedAssetRepository(void);

      virtual bool Initialize();

#if ((COURIER_VERSION_MAJOR > 3) || (COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 2))
      virtual SizeType AssetRead(void* buffer, SizeType elementSize, SizeType count);
      virtual bool AssetSeek(OffsetType offset, AssetSeekMark mark);
      virtual OffsetType AssetTell();
      virtual SizeType GetConstData(const void** buffer, SizeType elementSize, SizeType count);
#else
      // CGI 3.1
      virtual Int32 AssetRead(void* buffer, Int32 elementSize, Int32 count);
      virtual bool AssetSeek(Int32 offset, AssetSeekMark mark);
      virtual Int32 AssetTell();
      virtual Int32 GetConstData(const void** buffer, Int32 elementSize, Int32 count);
#endif

      virtual AssetAccessMode GetAssetAccessMode();

      virtual bool Finalize()
      {
         return finalize();
      }

   private:
      Char* mFileName;
      const UInt8* mBasePtr;
      const UInt8* mEndPtr;
      const UInt8* mReadPtr;
      int mFileHandle;

      SizeType CapByteSize(SizeType elementSize, SizeType count) const;

      bool finalize();

      HMIBASE_UNCOPYABLE(MemoryMappedAssetRepository)
};


}

#endif // MemoryMappedAssetRepository_h
