/* ***************************************************************************************
* FILE:          LayoutSizePropertySetter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LayoutSizePropertySetter.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(hmibase_layoutsizepropertysetters_H)
#define hmibase_layoutsizepropertysetters_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseNode2DPropertySetter.h>

namespace hmibase {
namespace view {
namespace animation {

/*****************************************************************************/
class LayoutSizePropertySetter : public Candera::Animation::BaseNode2DPropertySetter
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(LayoutSizePropertySetter);
      FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
      FEATSTD_RTTI_DECLARATION();

      virtual void Set(const FeatStd::Float* value) override;

   private:
      FEATSTD_TYPEDEF_BASE(LayoutSizePropertySetter);
};


/*****************************************************************************/
class LayoutSizeXPropertySetter : public Candera::Animation::BaseNode2DPropertySetter
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(LayoutSizeXPropertySetter);
      FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
      FEATSTD_RTTI_DECLARATION();

      virtual void Set(const FeatStd::Float* value) override;

   private:
      FEATSTD_TYPEDEF_BASE(LayoutSizeXPropertySetter);
};


/*****************************************************************************/
class LayoutSizeYPropertySetter : public Candera::Animation::BaseNode2DPropertySetter
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(LayoutSizeYPropertySetter);
      FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
      FEATSTD_RTTI_DECLARATION();

      virtual void Set(const FeatStd::Float* value) override;

   private:
      FEATSTD_TYPEDEF_BASE(LayoutSizeYPropertySetter);
};


}
}


}
#endif  // hmibase_layoutsizepropertysetters_H
