/* ***************************************************************************************
* FILE:          IViewMap.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IViewMap.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_VIEW_IVIEWMAP_H
#define HMIBASE_VIEW_IVIEWMAP_H

#include <FeatStd/Platform/Types.h>

namespace Courier {
   class View;
   class ViewId;
}

namespace hmibase {
    namespace view {
        class IViewMap
        {
        public:
           virtual const Courier::ViewId& ViewIdForHash(FeatStd::UInt32 hash) const = 0;
           virtual Courier::View* ViewForId(const Courier::ViewId& id) const = 0;
           virtual const Courier::ViewId& ViewIdForProfileID(const Courier::ViewId& id, unsigned int profileid) const = 0;
            
        };        
    }
}
#endif
