/* ***************************************************************************************
* FILE:          DataCompletionHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataCompletionHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DataCompletionHandler_H
#define __DataCompletionHandler_H

namespace hmibase {
   namespace view {

      typedef unsigned int TransitionHint;  // maybe a string or whatever later

      class IDataCompletionListener
      {
      public:
         virtual void onDataComplete(TransitionHint hint) = 0;
      };


      class DataCompletionHandler
      {
      public:
         DataCompletionHandler();
         virtual ~DataCompletionHandler();
         void notifyDataComplete(TransitionHint hint);
         bool setDataCompletionListener(IDataCompletionListener* listener, bool add, FeatStd::UInt32 timeout = 350);
         bool checkTimeout(::Util::Timer* const& timer);
      private:
         void timerDestroy();
         IDataCompletionListener* _listener;
         Util::Timer* _timer;

         DataCompletionHandler(const DataCompletionHandler&);
         DataCompletionHandler& operator=(const DataCompletionHandler&);
      };

   }
}
#endif
