/* ***************************************************************************************
* FILE:          DataBindingItem.hpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataBindingItem.hpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_DATABINDINGITEM_H)
#define _DATABINDINGITEM_H

/*
   DataBindingItem is a helper class for trace in implementation of DataBinding function SendUpdate()
   The base base class DataItemContainer holds all data of a binding source and provides functions to
   update this data to the other system components (controller / view)
 */

#include "DataBindingRealm.h"
#include "Courier/DataBinding/DataBindingMsg.h"
#include "View/CGI/CourierMsgTracing/DataBindingTrace.h"

//namespace hmibase {
//   namespace view {

      template<typename T> class DataBindingItem : public Courier::DataItemContainer<T>
      {
      public:
         DataBindingItem() {}

         bool SendUpdate(bool markAllAsModified = false)
         {
            if (markAllAsModified)
            {
               Courier::DataItemContainer<T>::MarkAllItemsModified();
            }
            Courier::DataItemMsg<T> *msg = COURIER_MESSAGE_NEW(Courier::DataItemMsg<T>)(*this);
            if (msg)
            {
               ::hmibase::view::DataBindingTrace::Trace(msg);
               msg->Post();
            }
            Courier::DataItemContainer<T>::ResetAllItemsModified();
            return true;
         }
      };

//   }
//}
#endif// _DATABINDINGITEM_H
