/* ***************************************************************************************
* FILE:          ColorAccessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ColorAccessor is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_COLOR_ACCESSOR__
#define __HMIBASE_COLOR_ACCESSOR__

#include <Candera/EngineBase/Common/Color.h>
#include <Candera/System/MetaInfo/DataType.h>


namespace hmibase {
namespace util {
namespace color {


/************************************************************************/
using Candera::Color;
typedef size_t ColorId;


/************************************************************************/
class ColorAccessor
{
   public:
      /************************************************************************/
      ColorAccessor();
      ColorAccessor(const Color& c);
      ColorAccessor(const Color::Data& colorData);
      explicit ColorAccessor(ColorId id);
      ~ColorAccessor();

      /************************************************************************/
      ColorAccessor& operator = (const Color& color);
      ColorAccessor& operator = (const Color::Data& colorData);
      ColorAccessor& operator = (ColorId id);

      /************************************************************************/
      bool operator == (const ColorAccessor& other) const;
      bool operator != (const ColorAccessor& other) const;
      bool operator == (const Color& otherColor) const;
      bool operator != (const Color& otherColor) const;
      bool operator == (const Color::Data& otherData) const;
      bool operator != (const Color::Data& otherData) const;

      /************************************************************************/
      bool isSystemColor() const
      {
         return _isSysColor;
      }

      /************************************************************************/
      ColorId getSystemColorId() const
      {
         return _data._sysColor._colorId;
      }

      /************************************************************************/
      const Color::Data& getColorData() const;
      operator const Color::Data& () const
      {
         return getColorData();
      }

   private:
      struct SysColor
      {
         ColorId _colorId;
         size_t _updateSeqNr;
         const Color* _color;
      };

      union ColorAccessorData
      {
         SysColor _sysColor;
         Color::Data _colorData;
      };

      bool _isSysColor;
      mutable ColorAccessorData _data;
};


}
}


}

namespace Candera {
namespace MetaInfo {

/************************************************************************/
template<> struct DataType<hmibase::util::color::ColorAccessor>
{
   static const FeatStd::Char* GetEditor()
   {
      return "custom://SysColorEditor";
   }
   static bool ConvertToString(const hmibase::util::color::ColorAccessor& accessor, FeatStd::Char* buf, FeatStd::UInt bufLen);
   static bool ConvertFromString(hmibase::util::color::ColorAccessor& accessor, const FeatStd::Char* buf);
};


}
}


#endif
