/* ***************************************************************************************
* FILE:          CanderaDefaults.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CanderaDefaults.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_VIEW_CANDERA_DEFAULTS_H
#define HMIBASE_VIEW_CANDERA_DEFAULTS_H


namespace hmibase {
namespace view {

/*
* Provides support to change default values in Candera.
* The default value of a property in SceneComposer should be the same as the value in Candera at runtime.
* To change a default value in SceneComposer set an environment variable.
* To change a default value at runtime call the setter from this class.
*/
class CanderaDefaults
{
   public:
      enum Filter { NearestFilter, BilinearFilter, AutomaticFilter };

      /*
      * Sets Candera::BitmapBrush::DefaultFilter.
      * To have this setter called in Scene Composer one must set the environment variable CANDERA_BITMAP_BRUSH_DEFAULT_FILTER with value NearestFilter, BilinearFilter or AutomaticFilter.
      */
      static void SetBitmapBrushFilter(Filter filter);

#ifdef WIN32
      static bool InitSCHost();
#endif
};


}
}


#endif
