/* ***************************************************************************************
* FILE:          CGIAppViewFactoryBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactoryBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _CGIAPPVIEWFACTORYBASE_H_
#define _CGIAPPVIEWFACTORYBASE_H_

#include "View/CGI/CgiExtensions/IViewMap.h"
#include "View/CGI/CgiExtensions/ViewControllerBase.h"

#include "Courier/Visualization/ViewFactory.h"

namespace hmibase {
   namespace view {

      struct SceneMapping;

      class CGIAppViewFactoryBase : public Courier::ViewFactory
         , public hmibase::view::IViewMap
      {
         CGIAppViewFactoryBase();
      public:
         CGIAppViewFactoryBase(unsigned short cnt, SceneMapping* sm);
         virtual ~CGIAppViewFactoryBase();

         // called by ViewHandler if method Create returns NULL in order to create a view scene which is managed by the view handler (managed means that it is deleted by the view handler without calling destroy from the view factory)
         virtual Courier::ViewScene* CreateViewScene(bool is2D);

         typedef Courier::ViewScene* (*CreateDefaultViewSceneFunc)(bool is2D, bool isManagedByViewHandler);
         // sets a custom factory method to create default view scenes
         static void SetCreateDefaultViewSceneFunc(CreateDefaultViewSceneFunc func);

         // creates a view scene; uses the custom factory method if it is set
         virtual Courier::ViewScene* CreateDefaultViewScene(bool is2D, bool isManagedByViewHandler);

         // creates a view scene; the specified name will be used to search in the asset the view scene type (2D or 3D).
         virtual Courier::ViewScene* CreateDefaultViewScene(const FeatStd::Char* viewName, bool isManagedByViewHandler);

         virtual const Courier::ViewId& ViewIdForHash(FeatStd::UInt32 hash) const;
         virtual Courier::View* ViewForId(const Courier::ViewId& id) const;
         virtual const Courier::ViewId& ViewIdForProfileID(const Courier::ViewId& id, unsigned int profileid) const;

      protected:
         unsigned short _viewCnt;
         SceneMapping* _scenes;

         enum enViewSceneType { enUndef, en2D, en3D };
         typedef std::map<Courier::HashId, enViewSceneType> ViewSceneTypeMapType;
         ViewSceneTypeMapType _viewSceneTypeMap;

         // custom method to create view scenes
         static CreateDefaultViewSceneFunc _createDefaultViewSceneFunc;

         // iterates through the asset and gets the name of all 2D and 3D scenes
         // TODO: this should be called again if an asset partition with scenes is loaded or unloaded
         void InitViewSceneTypeMap();

         // returns the view scene type associated with the specified name
         enViewSceneType GetViewSceneType(const FeatStd::Char* viewName);
      };
   }
}
HMIBASE_DEPRECATED_TYPE_ALIAS(CGIAppViewFactoryBase, hmibase::view::CGIAppViewFactoryBase);

#endif
