/* ***************************************************************************************
* FILE:          ArrayUtils.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ArrayUtils.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_ARRAY_UTILS_H__
#define __HMIBASE_ARRAY_UTILS_H__

#include <CanderaAssetLoader/AssetLoaderBase/ArrayProperty.h>

namespace hmibase {
namespace util {

class Arrays
{
   public:
      template <typename T>
      static bool equals(const Candera::ArrayProperty<T>& x, const Candera::ArrayProperty<T>& y)
      {
         //different objects
         if (&x != &y)
         {
            //different size
            if (x.GetCount() != y.GetCount())
            {
               return false;
            }

            //compare each item
            for (FeatStd::SizeType i = 0; i < x.GetCount(); ++i)
            {
               //different item
               if (x.Get(i) != y.Get(i))
               {
                  return false;
               }
            }
         }

         return true;
      }
};


}
}


#endif // __HMIBASE_ARRAY_UTILS_H__
