/* ***************************************************************************************
* FILE:          WidgetInstanceFinderCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetInstanceFinderCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef WIDGETINSTANCEFINDERCALLBACK_H_
#define WIDGETINSTANCEFINDERCALLBACK_H_

#include "View/IMessageSystem.h"

namespace hmibase {
namespace trace {
class WidgetInstanceFinderCallback : public WidgetCheckCallback
{
   public:
      explicit WidgetInstanceFinderCallback(const Candera::String& widgetName);
      virtual bool CheckWidget(Candera::Widget2D* widget);

      Candera::WidgetBase* getBaseWidget()
      {
         return _widget;
      }

   private:
      const Candera::String _widgetName;
      Candera::WidgetBase* _widget;

      // make it private so nobody can use it
      WidgetInstanceFinderCallback& operator=(const WidgetInstanceFinderCallback& rhs);
};


}	// namespace_trace
}	// namespace_hmibase

#endif // WIDGET_INSTANCE_FINDER_CALLBACK_HPP
