/* ***************************************************************************************
* FILE:          WidgetFinderCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetFinderCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef WIDGET_FINDER_CALLBACK_H_
#define WIDGET_FINDER_CALLBACK_H_

#include "View/IMessageSystem.h"

namespace hmibase {
namespace trace {
/** WidgetFinderCallback is used to get a callback from all the widgets in the current scene and
print their names.
*/
class WidgetFinderCallback : public WidgetCheckCallback
{
   public:
      /**
      Prints the widget name, based on the received input parameter (Candera::Widget2D*)
      */
      virtual bool CheckWidget(Candera::Widget2D* widget);
};


}	// namespace_trace
}	// namespace_hmibase

#endif // WIDGET_FINDER_CALLBACK_HPP
