/* ***************************************************************************************
* FILE:          WidgetFinderCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetFinderCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "WidgetFinderCallback.h"
#include "CanderaWidget/Widget.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/WidgetFinderCallback.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {
// ------------------------------------------------------------------------
bool WidgetFinderCallback::CheckWidget(Candera::Widget2D* widget)
{
   if (widget != NULL)
   {
      const FeatStd::Char* name = widget->GetLegacyName();

      if (name == 0)
      {
         name = widget->GetName();
      }
      const FeatStd::Char* widgetType = widget->GetTypeName();
      ETG_TRACE_FATAL_THR(("WidgetName = %100s, WidgetTemplate = %100s", name, widgetType));
   }
   return false;
}


} // namespace trace
}
