/* ***************************************************************************************
* FILE:          SurfaceInfoProvider.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceInfoProvider.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SURFACEINFOPROVIDER_H
#define SURFACEINFOPROVIDER_H

#include "View/MessagingDefines.h"
#include "hmibase/util/Geometry.h"
#include <vector>


namespace hmibase {
namespace trace {

struct surfaceInfoItem
{
   int surfaceId;
   ::hmibase::util::geometry::Rect touchableRect;

   surfaceInfoItem(int id, ::hmibase::util::geometry::Rect rect): surfaceId(id), touchableRect(rect) {}
};


class SurfaceInfoProvider
{
   public:
      typedef std::vector<surfaceInfoItem> tSurfaceInfoVector;

      SurfaceInfoProvider()
      {
      }

      SurfaceInfoProvider(tSurfaceInfoVector v): _surfaceInfoData(v)
      {
      }

      const tSurfaceInfoVector&  getSurfaceInfoData() const
      {
         return _surfaceInfoData;
      }

      void Release()
      {
         // todo: sat2hi
      }
      void Retain()
      {
         // todo: sat2hi
      }
   private:

      tSurfaceInfoVector _surfaceInfoData;
};


} // namespace
} // namespace

#endif // SURFACEINFOPROVIDER_H
