/* ***************************************************************************************
* FILE:          HMIAlert.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIAlert.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_UTILS_TRACE_HMIALERT_H

#define HMI_ALERT_CONDITIONAL(condition, args, ...)  \
	if(!condition) \
	{ \
		::hmibase::trace::HMIAlert(__FILE__, __LINE__, args, ## __VA_ARGS__); \
	}

#define HMI_ALERT( args, ...)  ::hmibase::trace::HMIAlert(__FILE__, __LINE__, args, ## __VA_ARGS__);

namespace hmibase {
namespace trace {
int HMIAlert(const std::string fileName, unsigned int lineNo, const std::string format, ...);
}


}


#endif
