/* ***************************************************************************************
* FILE:          HMIAlert.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIAlert.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"

#ifdef WIN32
#ifdef VARIANT_S_FTR_ENABLE_HMI_ALERT
#undef VARIANT_S_FTR_ENABLE_HMI_ALERT
#endif
#else
#include "hmi_alert_defines.h"
#include <unistd.h>
#include <string>
#endif

#ifdef VARIANT_S_FTR_ENABLE_HMI_ALERT
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

#include "lint_deactivation.h"
#include "HMIAlert.h"

#include "TraceUtils.h"


#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/HMIAlert.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace trace {
std::string string_format(const std::string fmt, ...)
{
   int size = ((int)fmt.size()) * 2 + 50;   // Use a rubric appropriate for your code
   std::string str;
   va_list ap;
   while (size > 0)       // Maximum two passes on a POSIX system...
   {
      str.resize(static_cast<size_t>(size));
      va_start(ap, fmt);
      int n = vsnprintf(const_cast<char*>(str.data()), static_cast<size_t>(size), fmt.c_str(), ap);
      va_end(ap);
      if (n > -1 && n < size)    // Everything worked
      {
         str.resize(static_cast<size_t>(n));
         return str;
      }
      if (n > -1)  // Needed size returned
      {
         size = n + 1;   // For null char
      }
      else
      {
         size *= 2;   // Guess at a larger size (OS specific)
      }
   }
   return str;
}


//int HMIAlert(std::string text, std::string fileName, unsigned int line)
int HMIAlert(const std::string fileName, unsigned int line, const std::string format, ...)
{
   char buf[10] = {0};
#ifdef WIN32
   sprintf(buf, "%u", line);
#else
   snprintf(buf, 10, "%u", line);
#endif

   std::string procName = hmibase::trace::getAppName();
   std::string lineNo = buf;

   fileName.find_last_of("/\\");

   va_list arglist;
   va_start(arglist, format);
   std::string text = string_format(format, arglist);
   va_end(arglist);


#ifdef WIN32
   std::string msg = "ASSERT in ";
   msg += procName + " [ " + fileName.substr(fileName.find_last_of("/\\") + 1) + "(" + lineNo + ") ]:\n\n" + text;
   ::MessageBox(0, msg.c_str(), hmibase::trace::getAppName().c_str(), MB_ICONERROR);
#endif

   text = procName + " [ " + fileName.substr(fileName.find_last_of("/\\") + 1) + "(" + lineNo + ") ]:\n\t\t\t\t" + text;
   ETG_TRACE_ERRMEM_THR(("%s", text.c_str()));

#ifdef VARIANT_S_FTR_ENABLE_HMI_ALERT
   int sockfd;
   ssize_t n;
   struct sockaddr_in serv_addr;
   struct hostent* server;

   sockfd = socket(AF_INET, static_cast<int>(SOCK_STREAM), 0);
   if (sockfd < 0)
   {
      ETG_TRACE_ERR_THR(("ERROR opening socket"));
      return -1;
   }
   server = gethostbyname("localhost");
   if (server == NULL)
   {
      ETG_TRACE_ERR_THR(("ERROR, no such host: stderr: %s", stderr));
      close(sockfd);
      return -1;
   }
   bzero((char*) &serv_addr, sizeof(serv_addr));
   serv_addr.sin_family = AF_INET;
   bcopy((char*)server->h_addr,
         (char*)&serv_addr.sin_addr.s_addr,
         static_cast<size_t>(server->h_length));
   serv_addr.sin_port = htons(HMI_ALERT_PORT_NO);
   if (connect(sockfd, (struct sockaddr*) &serv_addr, sizeof(serv_addr)) < 0)                                           //lint !e740
   {
      ETG_TRACE_ERR_THR(("ERROR connecting"));
   }
   n = write(sockfd, text.c_str(), text.size());
   if (n < 0)
   {
      ETG_TRACE_ERR_THR(("ERROR writing to socket"));
   }

   close(sockfd);
#endif
   return 0;
}


}
}
