/* ***************************************************************************************
* FILE:          LegacyTouchDetector.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LegacyTouchDetector is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#ifndef _RawGestureDetector_H
#define _RawGestureDetector_H

#include "GestureBasetypes.h"
#include "GestureDetector.h"

namespace hmibase {
namespace input {
namespace gesture {
class RawGestureDetector : public hmibase::input::gesture::GestureDetector
{
   public:
      /**
      *  @brief Initialize object.
      *
      *  Initialaze member variables with defauld values.
      *
      *  @param[in] receiver Receiver of the gesture events
      */
      RawGestureDetector(IGestureListener* receiver, int gesturePriority);

      /**
      *  @brief Un-Initialize object.
      *
      *  Frees all allocated memory.
      */
      virtual ~RawGestureDetector();

      /**
      *  @brief Get priority of the gesture
      *
      *  @return  Gesture priority (refers to GesturePriority enumeration)
      */
      virtual int  getPriority();

      /**
      *  @brief Cancel the gesture
      *
      *  Cancelling the gesture stops all internal timers (if any)
      *  and sends the abort command to gesture receiver (if needed).
      */
      virtual void cancel();

      /**
      *  @brief Detects the gesture
      *
      *  Function process the input touchMsg and checks if all conditions
      *  needed to detect a gesture are fulfilled. If yes - function will
      *  inform registered receiver about detecting the gesture.
      *
      *  @return True if the gesture was detected, false otherwise
      */
      virtual bool detect();

      /**
      *  @brief Register for the gesture detection.
      *
      *  This function adds object of this class to the list of gestures
      *  managed by GestureHandler.
      *
      *  @param[in] receiver Receiver of the gesture events
      */
      static bool registerGesture(IGestureListener* receiver, int priority);

   private:
      /**
      *  @brief  Detect the drag gesture start.
      *
      *  @return True if the gesture was detected, false otherwise
      */
      bool detectGestureStart();

      bool m_bGestureDetected;
      int _gesturePriority;
};


}
}


}

#endif // #ifndef _RawGestureDetector_H
