/* ***************************************************************************************
* FILE:          LegacyTouchDetector.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LegacyTouchDetector is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _LegacyTouchDetector_H
#define _LegacyTouchDetector_H

#include "GestureDetector.h"

namespace hmibase {
namespace input {
namespace gesture {
class LegacyTouchDetector : public hmibase::input::gesture::GestureDetector
{
   public:
      /**
      *  @brief Initialize object.
      *
      *  Initialize member variables with default values.
      *
      *  @param[in] receiver Receiver of the gesture events
      *  @param[in] gesturePriority
      */
      LegacyTouchDetector(IGestureListener* receiver, int gesturePriority);

      virtual ~LegacyTouchDetector();

      /**
      *  @brief Get priority of the gesture
      *
      *  @return  Gesture priority (refers to GesturePriority enumeration)
      *
      */
      virtual int getPriority();

      /**
      *  @brief Cancel the gesture
      *
      *  Cancelling the gesture stops all internal timers (if any)
      *  and sends the abort command to gesture receiver (if needed).
      */
      virtual void cancel();

      /**
      *  @brief Detects the gesture
      *
      *  Function process the input touchMsg and checks if all conditions
      *  needed to detect a gesture are fulfilled. If yes - function will
      *  inform registered receiver about detecting the gesture.
      *
      *
      *  @return True if the gesture was detected, false otherwise
      */
      virtual bool detect();

      /**
      *  @brief Register for the gesture detection.
      *
      *  This function adds object of this class to the list of gestures
      *  managed by GestureHandler.
      *
      *  @param[in] receiver Receiver of the gesture events
      *  @param[in] gesturePriority
      *
      *  @return true if the registration successful, false otherwise
      */
      static bool registerGesture(IGestureListener* receiver, int gesturePriority);

   private:
      int _gesturePriority;    //< used to Determine the Order of Gesture Detection
};


}
}


}

#endif // #ifndef _LegacyTouchDetector_H
