/* ***************************************************************************************
* FILE:          IGestureListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IGestureListener is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _IGestureListener_H
#define _IGestureListener_H

#include "GestureBasetypes.h"

namespace hmibase {
namespace input {
namespace gesture {

class IGestureListener
{
   public:

      virtual ~IGestureListener() {};

      /**
      *  @brief  Process a touch event.
      *
      *  @param[in]  gestureMsg  Gesture event
      *
      */
      virtual bool processGestureEvent(const hmibase::input::gesture::GestureEvent& gestureData) = 0;
      /**
      *  @brief Called To Get Receiver Dimensions
      *
      *
      */
      virtual GUI_Rect  getReceiverAbsoluteRect() = 0;
};


}
}


}

#endif // #ifndef _IGestureListener_H
