/* ***************************************************************************************
* FILE:          GestureListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GestureListener.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef GESTURELISTENER_H
#define GESTURELISTENER_H

#include "TouchGestures/IGestureListener.h"

namespace hmibase {
namespace input {
namespace gesture {

class GestureListener : public IGestureListener
{
   public:
      virtual ~GestureListener()
      {
      };

      virtual bool processGestureEvent(const GestureEvent& /*gestureData*/)
      {
         return false;
      }

      virtual GUI_Rect  getReceiverAbsoluteRect()
      {
         return GUI_Rect();
      }

      union GestureConfig
      {
         struct TapPressHoldRepeatConfig
         {
            bool doubleTapEnabled;
            unsigned int holdTime;
            unsigned int repeatTime;
            unsigned int doubleTapTime;
            int maxDistance;
         } tapPressHoldRepeatGestureParameter;

         struct DragNudgeConfig
         {
            GestureEvent::Direction direction;
            unsigned int holdTime;
            int holdMaxDistance;
            int minDistance;
         } dragGestureParameter;

         struct SwipeFlingConfig
         {
            GestureEvent::Direction direction;
            int minSpeed;
            int minDistance;
         } swipeGestureParameter;

         struct PinchSpreadConfig
         {
            unsigned int doubleTouchMaxTime;
            float spreadMinFactor;
            float pinchMaxFactor;
         } pinchGestureParameter;

         struct RotateConfig
         {
            unsigned int doubleTouchMaxTime;
            int minRotationAngle;
         } rotateGestureParameter;

         struct RawConfig
         {
            int dummy;
         } rawGestureParameter;

         struct LegacyTouchConfig
         {
            int dummy;
         } legacyTouchParameter;
      };                                                                                                                //lint !e1503 a tagged union is not anonymous

      struct Gesture
      {
         GestureEvent::GestureType _type;
         GestureConfig _config;
         bool _parallelEnabled;
         GestureEvent::GestureType _parallelType;

         Gesture() : _type(GestureEvent::GT_None), _parallelEnabled(false), _parallelType(GestureEvent::GT_None)
         {
            _config.legacyTouchParameter.dummy = 0;
         };
         Gesture(GestureEvent::GestureType type, const GestureConfig& config, bool parallelEnabled = false, GestureEvent::GestureType parallelType = GestureEvent::GT_None)
            : _type(type), _config(config), _parallelEnabled(parallelEnabled), _parallelType(parallelType) {};
      };

      struct GesturePriorizationParameter
      {
         uint32_t effectiveTouchPriority;
         uint32_t effectiveRenderOrderRank;

         GesturePriorizationParameter() : effectiveTouchPriority(0), effectiveRenderOrderRank(0)
         {
         }
      };

      typedef std::vector<Gesture> Gestures;
      virtual Gestures GetGestureList() const = 0;

      virtual GesturePriorizationParameter getGesturePriorizationParameter() const
      {
         return GesturePriorizationParameter();
      }
};


}
}


}

#endif // GESTURELISTENER_H
