/* ***************************************************************************************
* FILE:          GestureBasetypes.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GestureBasetypes is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _GestureBasetypes_H
#define _GestureBasetypes_H

#if defined(_MSC_VER)
# pragma warning( disable : 4100 )
#endif

#include <math.h>
#include <stdint.h>
#include <vector>

#define GESTURE_ASSERT(a)

#include "hmibase/util/Macros.h"
#include "hmibase/util/Geometry.h"

namespace hmibase {
namespace input {
namespace gesture {

typedef hmibase::util::geometry::Coord TouchCoord;
typedef hmibase::util::geometry::Point Vector2D;
typedef hmibase::util::geometry::Rect GUI_Rect;
typedef hmibase::util::geometry::Size GUI_Size;

/* Data Related To Touch Points */
struct GestureEvent
{
   GestureEvent() :
      _gestureType(GT_None),
      _gestureState(ET_None),
      _gestureDirection(DIR_NONE),
      _isPoint1Valid(false),
      _isPoint2Valid(false),
      _isPoint3Valid(false),
      _isPoint1VelocityValid(false),
      _isPoint2VelocityValid(false),
      _isPoint3VelocityValid(false),
      _rotateAngle(0),
      _nTimestamp(0)
   {
   }

   enum GestureType
   {
      GT_PressHoldRepeatTap,   //< used by buttons
      GT_DragNudge,            //< used for drag and drop, nudge scrolling
      GT_SwipeFling,           //< used for scrolling through large lists
      GT_PinchSpread,          //< used for zooming in and out(Two Finger Gesture)
      GT_Rotate,              //< Used for Rotating Map(Two Finger Gesture)
      GT_RawTouchData,         //< Sends Raw Touch Points
      GT_LegacyTouch,          // for legacy reasons, to be used as long as wiget is not adopted to gesture precedure
      GT_None = 0x30
   };

   enum GestureState
   {
      ET_INITIATE,			//< used to Indicate first touch point on screen from GT_PressHoldRepeatTap
      ET_START,               //< used for GT_PressHoldRepeatTap, GT_DragNudge, GT_PinchSpread
      ET_HOLD,                //< used for GT_PressHoldRepeatTap, GT_DragNudge
      ET_MOVE,                //< used for GT_DragNudge, GT_PinchSpread
      ET_REPEAT,              //< used for GT_PressHoldRepeatTap
      ET_END,                 //< used for all possible gestures
      ET_ABORT,               //< used for GT_PressHoldRepeatTap, GT_DragNudge, GT_PinchSpread
      ET_DT_START,            //< used for Indicating double tap start
      ET_RAW_DATA,
      ET_None
   };

   enum Direction
   {
      DIR_HORIZONTAL,         ///< horizontal movement detected
      DIR_VERTICAL,           ///< vertical movement detected
      DIR_CLOCKWISE,         /// < Rotate Gesture
      DIR_ANTICLOCKWISE,     /// < Rotate Gesture
      DIR_2D,                 ///< 2D movement detected
      DIR_NONE
   };

   GestureType			_gestureType;      //< kind of gesture (e.g. DragNudge)
   GestureState		_gestureState;     //< kind of event (e.g. END)
   Direction			_gestureDirection; //< direction; used for GT_DragNudge, GT_SwipeFling ,GT_Rotate
   Vector2D          _pt1;  //<
   Vector2D          _pt2;  //<
   Vector2D          _pt3;  //<
   bool              _isPoint1Valid;
   bool              _isPoint2Valid;
   bool              _isPoint3Valid;
   Vector2D          _velocity1;  //<
   Vector2D          _velocity2;  //<
   Vector2D          _velocity3;  //<
   bool              _isPoint1VelocityValid;
   bool              _isPoint2VelocityValid;
   bool              _isPoint3VelocityValid;
   int16_t             _rotateAngle;      //< to Store Rotate Angle
   int					_nTimestamp;	   //< time @ Which Gesture started
};


}
}


}

HMIBASE_DEPRECATED("Deprecated class ::GestureEvent, please use hmibase::input::gesture::GestureEvent instead", typedef ::hmibase::input::gesture::GestureEvent GestureEvent);


#endif // #ifndef _GestureBasetypes_H
