/* ***************************************************************************************
* FILE:          RootDaemon.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RootDaemon.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_ROOTDAEMONCLIENT_H
#define HMIBASE_ROOTDAEMONCLIENT_H

#include <string>
#include "RootDaemonTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum
{
   E_HMIBASE_ROOTDAEMON_CMD_CODE_NICE_LVL_FG,
   E_HMIBASE_ROOTDAEMON_CMD_CODE_NICE_LVL_BG,
   E_HMIBASE_ROOTDAEMON_CMD_CODE_THREAD_NICENESS_5,
   E_HMIBASE_ROOTDAEMON_CMD_CODE_CHOWN_DYN_PARTITION
} tenHmiBaseRootDaemonCmdCode;


CmdData HMIBASE_ROOTDAEMON_CALLER_PerformRootOp(/*const char* clientName,*/ tenHmiBaseRootDaemonCmdCode cmdNum, std::string args);


#ifdef __cplusplus
}


#endif

#endif //HMIBASE_ROOTDAEMONCLIENT_H
