/* ***************************************************************************************
* FILE:          StubHandlerMessaging.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StubHandlerMessaging.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "StubHandlerMessaging.h"

#ifdef VARIANT_S_FTR_ENABLE_HEADLESS_HMI_MASTER
#include "SM/MasterController.h"
#endif

namespace hmibase {
namespace services {
namespace hmiappctrl {

#ifdef VARIANT_S_FTR_ENABLE_HEADLESS_HMI_MASTER

void StubHandlerMessaging::postMsg(const ApplicationSwitchCompleteUpdMsg& msg)
{
}


void StubHandlerMessaging::postMsg(const ApplicationRenderedUpdMsg& msg)
{
}


void StubHandlerMessaging::postMsg(const EncoderStatusChangedUpdMsg& msg)
{
   //todo : once EK codes are added in BaseContract ; enable this code
   //if (msg.GetEncCode() == ENCCODE_LEFT_ENCODER)
   MasterController::getInstance()->acSetVolume(msg.GetEncSteps());
}


void StubHandlerMessaging::postMsg(const HKStatusChangedUpdMsg& msg)
{
   //todo : once HK codes are added in BaseContract ; enable this code
//   if ((msg.GetHKCode() == HARDKEYCODE_HMI_BASE_1) && (msg.GetHKState() == HARDKEYSTATE_UP))
   {
      MasterController::getInstance()->stateMachineDropEvent(MasterSM::evTriggerNextApplication);
   }
}


void StubHandlerMessaging::postMsg(const HMIAppsInitializedUpdMsg& msg)
{
   // all clients apps are initialized; send the message to master to show default client application
   MasterController::getInstance()->stateMachineDropEvent(MasterSM::evTriggerDefaultApplication);
}


void StubHandlerMessaging::postMsg(const PlayBeepReqMsg& msg)
{
}


#else
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, ApplicationSwitchCompleteUpdMsg);
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, ApplicationRenderedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, EncoderStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, HKStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, HMIAppsInitializedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(StubHandlerMessaging, PlayBeepReqMsg);
#endif
}// namespace hmiappctrl
}// namespace services
}// namespace hmibase
