/* ***************************************************************************************
* FILE:          SyncBlockConsumer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SyncBlockConsumer.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(SyncBlockConsumer_h)
#define SyncBlockConsumer_h

#include "Gadget/SyncBlock.h"

namespace hmibase {
namespace gadget {

class SyncBlockConsumer
   : public ConsumerType
{
   public:

      static SyncBlockConsumer& getInstance()
      {
         return *_theInstance;
      }

      void onUpdate(int inst);

      static void initialize(int key, int numberOfProducerInstances);
      static void kill()
      {
         if (_theInstance)
         {
            delete _theInstance;
            _theInstance = 0;
         }
      }

      int exchangeFramebuffer(int inst);

   private:

      SyncBlockConsumer(void);
      SyncBlockConsumer(int key, int numberOfProducerInstances);
      ~SyncBlockConsumer(void) {};

      static SyncBlockConsumer* _theInstance;
};


}
}


#endif
