/* ***************************************************************************************
* FILE:          SyncBlockConsumer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SyncBlockConsumer.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "SyncBlockConsumer.h"

#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SyncBlockConsumer.cpp.trc.h"
#endif

namespace hmibase {
namespace gadget {

SyncBlockConsumer* SyncBlockConsumer::_theInstance = 0;

void SyncBlockConsumer::initialize(int key, int numberOfProducerInstances)
{
   if (_theInstance == 0)
   {
      _theInstance = new SyncBlockConsumer(key, numberOfProducerInstances);
   }
}


SyncBlockConsumer::SyncBlockConsumer(int key, int numberOfProducerInstances)
   : ConsumerType(key)
{
   this->create(numberOfProducerInstances, true);
}


void SyncBlockConsumer::onUpdate(int inst)
{
#if defined(VARIANT_S_FTR_ENABLE_COURIERMESSAGING)
   // send individual messages as they can be consumed by dedicated widget instance
   std::vector<Courier::Int32> temp;
   temp.push_back(static_cast<Courier::Int32>(inst));
   hmibase::gadget::ConsumerMsg* consumerMsg = COURIER_MESSAGE_NEW(hmibase::gadget::ConsumerMsg)(temp);
   if (NULL != consumerMsg)
   {
      if (consumerMsg->Post())
      {
         ETG_TRACE_USR4_THR(("SyncBlockConsumer: hmibase::gadget::ConsumerMsg posted instanceId %d", temp[0]));
      }
      else
      {
         ETG_TRACE_ERR_THR(("SyncBlockConsumer: hmibase::gadget::ConsumerMsg post failed for instanceId %d", temp[0]));
      }
   }

   hmibase::gadget::ProviderUpdateIndicationMsg* providerUpdIndMsg = COURIER_MESSAGE_NEW(hmibase::gadget::ProviderUpdateIndicationMsg)(temp);
   if (providerUpdIndMsg)
   {
      providerUpdIndMsg->Post();
   }

#else
   PARAM_UNUSED(inst);
#endif
}


int SyncBlockConsumer::exchangeFramebuffer(int inst)
{
   return this->exchange(inst);
}


}
}
