/* ***************************************************************************************
* FILE:          FUtils.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FUtils.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_UTILS_H__
#define __FOCUS_UTILS_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"
#include "FContainer.h"
#include "FDataSet.h"
#include "FConfigInfo.h"
#include "FActiveViewGroup.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FUtils
{
   public:
      template <typename TData>
      static TData* getData(Focusable* f)
      {
         FGroup* group = dynamic_cast<FGroup*>(f);
         if (group != NULL)
         {
            return group->getData<TData>();
         }

         FWidget* widget = dynamic_cast<FWidget*>(f);
         if (widget != NULL)
         {
            return widget->getData<TData>();
         }

         return NULL;
      }

      static bool isDetailedTraceActive();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
      typedef FeatStd::FixedSizeStringBuffer<10240> TraceBufferType;
      static TraceBufferType::StringType& getTraceBuffer()
      {
         static TraceBufferType::StringType buffer;
         return buffer;
      }

      template <typename TItem>
      static void printItemTrace(const TItem& item, bool forcePrint = false)
      {
         const bool traceEnabled = forcePrint || isDetailedTraceActive();
         if (traceEnabled)
         {
            TraceBufferType::StringType& text = getTraceBuffer();
            TraceBufferType stringBuffer(text);

            unsigned int length = stringBuffer.AppendObject(item);
            printTextTrace(const_cast<FeatStd::TChar*>(text.CStr()), length);
            text.Clear();
         }
      }
#else
      template <typename TItem>
      static void printItemTrace(const TItem&)
      {
      }
#endif
      static void printTextTrace(char* text, unsigned int length);
};


}
#endif
