/* ***************************************************************************************
* FILE:          FTask.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FTask.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FTask.h"
#include "FManager.h"
#include "FSession.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FTask.cpp.trc.h"
#endif

namespace Focus {

FTask::Result FSessionUpdater::execute()
{
   FSession* session = _manager.getSession();
   if (session != NULL)
   {
      return update(*session);
   }
   return FTask::Completed;
}


bool FSessionUpdater::updateAllApps(FSession& session)
{
   bool result = true;
   for (size_t i = 0; i < session.ConfigInfo.count(); ++i)
   {
      FAppConfigSharedPtr appConfig = session.ConfigInfo.getAt(i);
      if (!appConfig.PointsToNull())
      {
         result = updateApp(session, appConfig) && result;
      }
   }
   return result;
}


bool FSessionUpdater::updateAllViews(FSession& session, FAppConfigSharedPtr appConfig)
{
   bool result = true;
   if (!appConfig.PointsToNull())
   {
      for (size_t i = 0; i < appConfig->getChildCount(); ++i)
      {
         FViewConfig* viewConfig = appConfig->getChild(i);
         if (viewConfig != NULL)
         {
            result = updateView(session, *viewConfig) && result;
         }
      }
   }
   return result;
}


bool FSessionUpdater::updateAllWidgets(FSession& session, FViewConfig& viewConfig)
{
   bool result = true;
   for (size_t i = 0; i < viewConfig.getChildCount(); ++i)
   {
      FWidgetConfig* widgetConfig = viewConfig.getChild(i);
      if (widgetConfig != NULL)
      {
         result = updateWidget(session, *widgetConfig) && result;
      }
   }
   return result;
}


}
