/* ***************************************************************************************
* FILE:          FSession.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FSession.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_SESSION_H__
#define __FOCUS_SESSION_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"
#include "FDataSet.h"
#include "FConfigInfo.h"
#include "FStateInfo.h"
#include "FActiveViewGroup.h"

namespace Focus {

//////////////////////////////////////////////////////////////////////////////////////////////
class FSession
{
   public:
      /////////////////////////////////////////////////////////////////////////
      enum Mode
      {
         Master,
         QueryingSlave,
         UpdatingSlave
      };

      /////////////////////////////////////////////////////////////////////////
      enum Status
      {
         New,
         Collecting,
         Processing,
         Refreshing,
         Publishing,
         Finished
      };

      /////////////////////////////////////////////////////////////////////////
      FSession(Mode mode);
      ~FSession();

      void printDebug() const;

      //generates the next sequence number for this session
      unsigned int generateSequenceNr()
      {
         return ++_sequenceNr;
      }

      /////////////////////////////////////////////////////////////////////////
      Mode getMode() const
      {
         return _mode;
      }
      Status getStatus() const
      {
         return _status;
      }
      void setStatus(Status status)
      {
         _status = status;
      }

      /////////////////////////////////////////////////////////////////////////
      FAppConfigSharedPtr getCurrentAppConfig()
      {
         return _currentAppConfig;
      }
      void resetCurrentAppConfig();

      FConfigInfo ConfigInfo;
      FStateInfo StateInfo;

      /////////////////////////////////////////////////////////////////////////
      FActiveViewGroup ActiveViewGroup;
      FDataSet Data;

   private:
      FSession(const FSession&);
      FSession& operator=(const FSession&);

      Mode _mode;
      Status _status;
      FAppConfigSharedPtr _currentAppConfig;
      unsigned int _sequenceNr;
};


}
#endif
