/* ***************************************************************************************
* FILE:          FIpc.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FIpc.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include <algorithm>

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FIpc.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FIpc.cpp.trc.h"
#endif

namespace Focus {

void FIpcAdapter::addReceiver(Focus::FIpcReceiver& receiver)
{
   _receivers.push_back(&receiver);
}


void FIpcAdapter::removeReceiver(Focus::FIpcReceiver& receiver)
{
   ReceiversType::iterator it = std::find(_receivers.begin(), _receivers.end(), &receiver);
   if (it != _receivers.end())
   {
      _receivers.erase(it);
   }
}


void FIpcAdapter::notifyCurrentAppInfoRequestReceived()
{
   for (ReceiversType::iterator it = _receivers.begin(); it != _receivers.end(); ++it)
   {
      Focus::FIpcReceiver* receiver = *it;
      if (receiver != NULL)
      {
         receiver->onCurrentAppInfoRequestReceived();
      }
   }
}


void FIpcAdapter::notifyCurrentAppStateReceived(Focus::FAppStateSharedPtr appState)
{
   for (ReceiversType::iterator it = _receivers.begin(); it != _receivers.end(); ++it)
   {
      Focus::FIpcReceiver* receiver = *it;
      if (receiver != NULL)
      {
         receiver->onCurrentAppStateReceived(appState);
      }
   }
}


void FIpcAdapter::notifyOtherAppInfoReceived(Focus::FAppConfigSharedPtr appConfig, Focus::FAppStateSharedPtr appState)
{
   for (ReceiversType::iterator it = _receivers.begin(); it != _receivers.end(); ++it)
   {
      Focus::FIpcReceiver* receiver = *it;
      if (receiver != NULL)
      {
         receiver->onOtherAppInfoReceived(appConfig, appState);
      }
   }
}


void FIpcAdapter::notifyOtherAppsInfoReceiveCompleted()
{
   for (ReceiversType::iterator it = _receivers.begin(); it != _receivers.end(); ++it)
   {
      Focus::FIpcReceiver* receiver = *it;
      if (receiver != NULL)
      {
         receiver->onOtherAppsInfoReceiveCompleted();
      }
   }
}


}
