/* ***************************************************************************************
* FILE:          FDataSet.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDataSet.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DATA_SET_H__
#define __FOCUS_DATA_SET_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/

namespace Focus {

/**************************************************************************/
/* DATA                                                                   */
/**************************************************************************/
//class FData
//{
//public:
//   /* Returns various fields from this data item or NULL if they are not available. */
//   template <typename TData> TData* get();

//   /* This implementation stores widget data for each focusable item. */
//   FWidgetData _widgetData;
//   /* This implementation stores group data for each focusable item. */
//   FGroupData _groupData;
//};

class FDataSet
{
   public:
      FDataSet() : _first(NULL) {}

      ~FDataSet()
      {
         if (_first != NULL)
         {
            FOCUS_DELETE(_first);
            _first = NULL;
         }
      }

      void reset()
      {
         if (_first != NULL)
         {
            FOCUS_DELETE(_first);
            _first = NULL;
         }
      }

      template<typename TData>
      void set(const TData& data)
      {
         FDataTypeId typeId = FDataWrapper<TData>::getDataTypeId();
         for (FDataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               ((static_cast<FDataWrapper<TData>*>(it))->Data) = data;
               return;
            }
         }

         FDataWrapper<TData>* newWrapper = FOCUS_NEW(FDataWrapper<TData>)(_first);
         if (newWrapper != NULL)
         {
            newWrapper->Data = data;
            _first = newWrapper;
         }
      }

      template<typename TData>
      bool has()
      {
         FDataTypeId typeId = FDataWrapper<TData>::getDataTypeId();
         for (FDataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               return true;
            }
         }

         return false;
      }

      template<typename TData>
      TData* get()
      {
         FDataTypeId typeId = FDataWrapper<TData>::getDataTypeId();
         for (FDataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               return &((static_cast<FDataWrapper<TData>*>(it))->Data);
            }
         }

         return NULL;
      }

      template<typename TData>
      TData* getOrCreate()
      {
         TData* data = get<TData>();

         if (data == NULL)
         {
            FDataWrapper<TData>* newWrapper = FOCUS_NEW(FDataWrapper<TData>)(_first);
            if (newWrapper != NULL)
            {
               data = &(newWrapper->Data);
               _first = newWrapper;
            }
         }

         return data;
      }

   private:
      FDataSet(const FDataSet&);
      FDataSet& operator=(const FDataSet&);

      typedef const char* FDataTypeId;

      class FDataWrapperBase
      {
         public:
            FDataWrapperBase(FDataWrapperBase* next) : _next(next) {}

            virtual ~FDataWrapperBase()
            {
               if (_next != NULL)
               {
                  FOCUS_DELETE(_next);
                  _next = NULL;
               }
            }

            FDataWrapperBase* getNext() const
            {
               return _next;
            }

            virtual bool isType(FDataTypeId id) const = 0;

         private:
            FDataWrapperBase* _next;
      };

      template<typename TData>
      class FDataWrapper : public FDataWrapperBase
      {
         public:
            FDataWrapper(FDataWrapperBase* next) : FDataWrapperBase(next) {}
            TData Data;

            virtual bool isType(FDataTypeId id) const
            {
               return id == getDataTypeId();
            }

            static FDataTypeId getDataTypeId()
            {
               static char c = '\0';
               return &c;
            }
      };

      FDataWrapperBase* _first;
};


typedef FDataSet FData;
}


#endif
