/* ***************************************************************************************
* FILE:          FData.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FData.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DATA_H__
#define __FOCUS_DATA_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"

namespace Focus {

/**************************************************************************/
/* WIDGET DATA                                                            */
/**************************************************************************/
class FWidgetData
{
   public:
      FWidgetData() :
         Enabled(true),
         SequenceNr(-1),
         Order(FocusOrderType()),
         EffectiveOrder(FocusOrderType()),
         ControllerSetId(Constants::InvalidControllerSetId)
      {
      }

      /* Widget is enabled or not. */
      bool Enabled;

      /* Identifies the order in which the widgets processed the request from the focus manager to register themselves into the current session. */
      int SequenceNr;

      /* Focus order as it was configured at design time. */
      FocusOrderType Order;

      /* Effective focus order obtain using also the order of the parents. */
      FocusOrderType EffectiveOrder;

      /* identifies the controller set used for this widget. */
      FControllerSetId ControllerSetId;
};


/**************************************************************************/
/* GROUP DATA                                                             */
/**************************************************************************/
class FGroupData
{
   public:
      FGroupData() :
         Configured(false),
         WrapAround(FConfiguration::getDefaultWrapAround()),
         PreserveFocus(FConfiguration::getDefaultPreserveFocus()),
         DefaultOrder(FocusOrderType()),
         Layer(FocusLayerType()),
         AnchorMode(FAnchorMode::None),
         AnchorId(FAnchorId())
      {
      }

      /* Indicates if the configuration of this group is valid. Otherwise a master group with the same id should exist in another view. */
      bool Configured;

      /* Wrap around policy for this group. */
      bool WrapAround;

      /* Preserves current focus info when this group loses focus. */
      bool PreserveFocus;

      /* Focus order of the default focused child. */
      FocusOrderType DefaultOrder;

      /* Focus layer into which this group operates. */
      FocusLayerType Layer;

      /* Anchor Mode */
      FAnchorMode::Enum AnchorMode;

      /* Anchor Id */
      FAnchorId AnchorId;
};


/**************************************************************************/
/* LIST DATA                                                             */
/**************************************************************************/
class FListData
{
   public:
      FListData() : ListId(-1), FirstVisibleIndex(0), VisibleItemCount(0), TotalItemCount(0) {}

      int ListId;
      int FirstVisibleIndex;
      int VisibleItemCount;
      int TotalItemCount;
};


/**************************************************************************/
/* LIST ITEM DATA                                                         */
/**************************************************************************/
class FListItemData
{
   public:
      FListItemData() : ListId(-1), Index(-1) {}

      int ListId;
      int Index;
};


/**************************************************************************/
/* base class for markers                                                 */
/**************************************************************************/
struct FMarkerData
{
   protected:
      FMarkerData(bool value) : Value(value) {}

   public:
      bool Value;
};


/**************************************************************************/
/* CAMERA DATA                                                            */
/**************************************************************************/
class FCameraData
{
   public:
      FCameraData() : DisplayId(0), DisplayOffset()
      {
      }

      /* Display in which this camera renders. */
      unsigned int DisplayId;

      /* Offset of the area updated by this camera related to display origin. */
      FCoordinate DisplayOffset;
};


typedef std::vector<FCameraData> FCameraDataVector;
}


#endif
