/* ***************************************************************************************
* FILE:          FCourierAdapter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FCourierAdapter.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_COURIER_ADAPTER_H__
#define __FOCUS_COURIER_ADAPTER_H__

#include <queue>

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"
#include "FContainer.h"
#include "FManager.h"
#include "FManagerConfig.h"

class AppViewHandler;
namespace Util {
class Timer;
}


namespace Focus {

//////////////////////////////////////////////////////////////////////////////////////////////
class FCourierMessageQueue : public FMsgQueue
{
   public:
      FCourierMessageQueue() {}
      virtual ~FCourierMessageQueue();

      virtual void clear();
      virtual size_t count() const;
      virtual bool empty() const;

      virtual void pushBack(const FMessage& msg);
      virtual void popFront();
      virtual const FMessage* front() const;

   private:
      FCourierMessageQueue(const FCourierMessageQueue&);
      FCourierMessageQueue& operator=(const FCourierMessageQueue&);

      std::queue<Courier::MessageReferrer*> _queue;
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FCourierOutputMsgHandler : public FOutputMsgHandler
{
   public:
      FCourierOutputMsgHandler(AppViewHandler& viewHandler) : _viewHandler(viewHandler) {}
      virtual ~FCourierOutputMsgHandler() {}

      virtual bool dispatchToView(const FViewId& viewId, const FMessage& msg);
      virtual bool dispatchToViews(const FMessage& msg);

      virtual void postMessage(FMessage* msg);
      virtual void postFocusUpdateMessage(const FViewId& viewId, const FId& widgetId);

      virtual bool focusWidget(const FViewId& viewId, const FId& widgetId);
      virtual bool unfocusWidget(const FViewId& viewId, const FId& widgetId);

   private:
      FCourierOutputMsgHandler(const FCourierOutputMsgHandler&);
      FCourierOutputMsgHandler& operator=(const FCourierOutputMsgHandler&);

      AppViewHandler& _viewHandler;
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FCourierTimer : public FTimer, public FMsgReceiver
{
   public:
      FCourierTimer(FTimerTimeout timeout = 1000);
      virtual ~FCourierTimer();

      virtual void restart();
      virtual void stop();

      virtual void setTimeout(FTimerTimeout timeout);
      virtual FTimerTimeout getTimeout() const
      {
         return _timeout;
      }

      virtual void addListener(FTimerListener& listener);
      virtual void removeListener(FTimerListener& listener);

      virtual bool onMessage(const FMessage& msg);

   private:
      FCourierTimer(const FCourierTimer&);
      FCourierTimer& operator=(const FCourierTimer&);

      void onExpired();

      Util::Timer* _timer;
      FTimerTimeout _timeout;
      typedef FVectorContainer<FTimerListener> ActivityTimerListenersType;
      ActivityTimerListenersType _listeners;
};


class FCourierInputMsgChecker : public FInputMsgChecker
{
   public:
      virtual bool isFocusInputMessage(const FMessage& msg) const;
};


}

#endif
