/* ***************************************************************************************
* FILE:          FController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_CONTROLLER_H__
#define __FOCUS_CONTROLLER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"
#include "FContainer.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class Focusable;
class FWidget;
class FGroup;
class FSession;
class FWidgetConfig;

/**************************************************************************/
/* CONTROLLER BASE CLASS                                                  */
/* Processes focus related messages and updates current focused item.     */
/**************************************************************************/
class FController
{
   public:
      virtual ~FController() {}

      //called when focus data is being collected from the focusable widgets in the active views
      virtual bool configureWidget(FSession&, FWidgetConfig&, FFrameworkWidget&)
      {
         return true;
      }

      //called when the current focus is being determined
      virtual Focusable* getFocus(FSession&, FGroup&)
      {
         return NULL;
      }

      //called when focus moves inside this group to filter out children which are not reachable
      virtual bool refreshReachableChildren(FSession&, FGroup&)
      {
         return false;
      }

      //handles focus input messages
      virtual bool onMessage(FSession&, FWidget&, const FMessage&)
      {
         return false;
      }
      virtual bool onMessage(FSession&, FGroup&, const FMessage&)
      {
         return false;
      }
};


/**************************************************************************/
/**************************************************************************/
class FControllerList
{
   public:
      void add(FController* c);
      void remove(const FController* c);
      void removeAll();
      size_t count() const;
      FController* operator[](size_t i) const;

   private:
      std::vector<FController*> _controllers;
};


/**************************************************************************/
/**************************************************************************/
class FControllerListMap
{
   public:
      FControllerListMap() : _map(true) {}
      ~FControllerListMap() {}

      const FControllerList* getList(FControllerSetId setId) const;
      void add(FControllerSetId setId, FController* controller);
      void remove(FControllerSetId setId, const FController* controller);
      void removeAll(FControllerSetId setId);

   private:
      FControllerListMap(const FControllerListMap&);
      FControllerListMap& operator=(const FControllerListMap&);

      typedef FMapContainer<FControllerSetId, FControllerList> MapType;
      MapType _map;
};


}
#endif
