/* ***************************************************************************************
* FILE:          FController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FController.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FController.h"
#include "FActiveViewGroup.h"
#include "FContainer.h"
#include "FDataSet.h"
#include "FManager.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FController.cpp.trc.h"
#endif

namespace Focus {
void FControllerList::add(FController* c)
{
   _controllers.push_back(c);
}


void FControllerList::remove(const FController* c)
{
   FContainerUtils::remove(_controllers, c);
}


void FControllerList::removeAll()
{
   _controllers.clear();
}


size_t FControllerList::count() const
{
   return _controllers.size();
}


FController* FControllerList::operator[](size_t i) const
{
   return _controllers[i];
}


const FControllerList* FControllerListMap::getList(FControllerSetId setId) const
{
   FControllerList* controllerList = _map.get(setId);
   return controllerList;
}


void FControllerListMap::add(FControllerSetId setId, FController* controller)
{
   FControllerList* controllerList = _map.get(setId);
   if (controllerList == NULL)
   {
      controllerList = FOCUS_NEW(FControllerList);
      if (controllerList != NULL)
      {
         _map.add(setId, controllerList);
         controllerList->add(controller);
      }
   }
   else
   {
      controllerList->add(controller);
   }
}


void FControllerListMap::remove(FControllerSetId setId, const FController* controller)
{
   FControllerList* controllerList = _map.get(setId);
   if (controllerList != NULL)
   {
      controllerList->remove(controller);
   }
}


void FControllerListMap::removeAll(FControllerSetId setId)
{
   FControllerList* controllerList = _map.get(setId);
   if (controllerList != NULL)
   {
      controllerList->removeAll();
   }
}


}
