/* ***************************************************************************************
* FILE:          FCommon.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FCommon.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FCommon.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FCommon.cpp.trc.h"
#endif

namespace Focus {
const FAppId Constants::InvalidAppId(-1);
const FViewId Constants::InvalidViewId("");
const FId Constants::InvalidId("");

bool FConfiguration::_defaultWrapAround = false;
bool FConfiguration::_defaultPreserveFocus = true;

FSequenceId FSequenceId::generate()
{
   static int nextId = 1;
   FSequenceId id;
   id.Id = nextId++;
   return id;
}


FViewWidgetId& FViewWidgetId::operator=(const FViewWidgetId& other)
{
   if (&other != this)
   {
      ViewId = other.ViewId;
      WidgetId = other.WidgetId;
   }
   return *this;
}


FAppViewWidgetId& FAppViewWidgetId::operator=(const FAppViewWidgetId& other)
{
   if (&other != this)
   {
      AppId = other.AppId;
      ViewId = other.ViewId;
      WidgetId = other.WidgetId;
   }
   return *this;
}


}
