/* ***************************************************************************************
* FILE:          FActiveViewGroup.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FActiveViewGroup.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FActiveViewGroup.h"
#include "FStateInfo.h"
#include "FGroupTraverser.h"
#include <Focus/FManager.h>

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FActiveViewGroup.cpp.trc.h"
#endif

namespace Focus {
//template <>
//FWidgetData* FData::get<FWidgetData>()
//{
//   return &_widgetData;
//}
//
//template <>
//FGroupData* FData::get<FGroupData>()
//{
//   return &_groupData;
//}

Focusable::Focusable(const FId& id) : _id(id), _parent(NULL)
{
}


Focusable::~Focusable()
{
   _parent = NULL;
}


void Focusable::setParent(FGroup* parent)
{
   _parent = parent;
}


void FWidget::visit(FocusableVisitor& visitor)
{
   visitor.visitWidget(*this);
}


void FGroup::visit(FocusableVisitor& visitor)
{
   visitor.visitGroup(*this);
}


void FGroup::refreshReachableChildren(FSession& session)
{
   ReachableChildren.removeAll();

   bool done = false;
   FWidgetData* config = getData<FWidgetData>();
   if (config != NULL)
   {
      const FControllerList* controllerList = FManager::getInstance().getControllerSet(config->ControllerSetId);
      if (controllerList != NULL)
      {
         for (size_t i = 0; !done && (i < controllerList->count()); ++i)
         {
            FController* controller = (*controllerList)[i];
            //a controller refreshed the reachable children => stop further filtering
            if ((controller != NULL) && controller->refreshReachableChildren(session, *this))
            {
               done = true;
            }
         }
      }
   }

   //by default all children are reachable
   if (!done)
   {
      ReachableChildren.addAll(Children);
   }
}


FActiveViewGroup::FActiveViewGroup() : Groups(true), Widgets(true), Anchors(false)
{
   FGroup* rootGroup = FOCUS_NEW(FGroup)(Constants::InvalidId);
   if (rootGroup != NULL)
   {
      Groups.add(rootGroup->getId(), rootGroup);
   }
}


void FActiveViewGroup::reset()
{
   ETG_TRACE_USR4_THR(("FActiveViewGroup::reset app=%d", FManager::getInstance().getCurrentAppId()));

   Views.clear();
   Widgets.removeAll();
   Groups.removeAll();
   FocusableList.clear();
   Anchors.removeAll();

   FGroup* rootGroup = FOCUS_NEW(FGroup)(Constants::InvalidId);
   if (rootGroup != NULL)
   {
      Groups.add(rootGroup->getId(), rootGroup);
   }
}


}
