/* ***************************************************************************************
* FILE:          FDefaultVisibilityManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultVisibilityManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_VISIBILITY_MANAGER_H__
#define __FOCUS_DEFAULT_VISIBILITY_MANAGER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FConfigInfo.h"
#include "Focus/FStateInfo.h"
#include "Focus/FManager.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FSession;
class FManager;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultVisibilityManager : public FVisibilityManager
{
   public:
      FDefaultVisibilityManager(FManager& manager);
      virtual ~FDefaultVisibilityManager();

      virtual bool isFocusVisible() const;
      virtual void setFocusVisible(bool visible);

   protected:
      FManager& _manager;

      //indicates if the focus is visible
      bool _isFocusVisible;

   private:
      FDefaultVisibilityManager(const FDefaultVisibilityManager&);
      FDefaultVisibilityManager& operator=(const FDefaultVisibilityManager&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FViewSpecificVisibilityManager : public FVisibilityManager
{
   public:
      FViewSpecificVisibilityManager(FManager& manager);
      virtual ~FViewSpecificVisibilityManager();

      virtual bool isFocusVisible() const;
      virtual void setFocusVisible(bool visible);

   protected:
      FManager& _manager;

   private:
      FViewSpecificVisibilityManager(const FViewSpecificVisibilityManager&);
      FViewSpecificVisibilityManager& operator=(const FViewSpecificVisibilityManager&);
};


}

#endif
