/* ***************************************************************************************
* FILE:          FDefaultVisibilityManager.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultVisibilityManager.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultVisibilityManager.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FSession.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultVisibilityManager.cpp.trc.h"
#endif

namespace Focus {

FDefaultVisibilityManager::FDefaultVisibilityManager(FManager& manager) :
   _manager(manager),
   _isFocusVisible(false)
{
}


FDefaultVisibilityManager::~FDefaultVisibilityManager()
{
}


bool FDefaultVisibilityManager::isFocusVisible() const
{
   return _isFocusVisible;
};


void FDefaultVisibilityManager::setFocusVisible(bool visible)
{
   if (_isFocusVisible != visible)
   {
      ETG_TRACE_USR1_THR(("FDefaultVisibilityManager::setFocusVisible app=%d, visible=%u",
                          _manager.getCurrentAppId(), visible));

      _isFocusVisible = visible;
   }
}


FViewSpecificVisibilityManager::FViewSpecificVisibilityManager(FManager& manager) :
   _manager(manager)
{
}


FViewSpecificVisibilityManager::~FViewSpecificVisibilityManager()
{
}


//returns true if the visibility flag is set in at least one of the active views
bool FViewSpecificVisibilityManager::isFocusVisible() const
{
   FAppStateSharedPtr appState = _manager.getCurrentAppState();
   if (!appState.PointsToNull())
   {
      for (size_t i = 0; i < appState->getChildCount(); ++i)
      {
         FViewState* viewState = appState->getChild(i);
         if ((viewState != NULL) && _manager.isViewActive(viewState->getId()))
         {
            FViewFocusVisible* viewFocusVisible = viewState->getData<FViewFocusVisible>();
            if ((viewFocusVisible != NULL) && (viewFocusVisible->Visible))
            {
               return true;
            }
         }
      }
   }
   return false;
};


//sets the visibility flag for all active views
void FViewSpecificVisibilityManager::setFocusVisible(bool visible)
{
   ETG_TRACE_USR1_THR(("FViewSpecificVisibilityManager::setFocusVisible app=%d, visible=%u", _manager.getCurrentAppId(), visible));

   FAppStateSharedPtr appState = _manager.getCurrentAppState();
   if (!appState.PointsToNull())
   {
      const FViewId& focusedViewId = appState->CurrentFocusInfo.ViewId;
      ETG_TRACE_USR1_THR(("FViewSpecificVisibilityManager::setFocusVisible FocusedView=%s", FVIEWID_STR(focusedViewId)));

      for (size_t i = 0; i < appState->getChildCount(); ++i)
      {
         FViewState* viewState = appState->getChild(i);
         if ((viewState != NULL) && _manager.isViewActive(viewState->getId()))
         {
            bool isViewFocusVisible = visible && (viewState->getId() == focusedViewId);
            FViewFocusVisible* viewFocusVisible = viewState->getOrCreateData<FViewFocusVisible>();

            if ((viewFocusVisible != NULL) && (viewFocusVisible->Visible != isViewFocusVisible))
            {
               ETG_TRACE_USR1_THR(("FViewSpecificVisibilityManager::setFocusVisible Set FocusVisible=%u for View=%s",
                                   isViewFocusVisible, FVIEWID_STR(viewState->getId())));
               viewFocusVisible->Visible = isViewFocusVisible;
            }
         }
      }
   }
   else
   {
      ETG_TRACE_USR1_THR(("FViewSpecificVisibilityManager::setFocusVisible Current app state is NULL!"));
   }
}


}
