/* ***************************************************************************************
* FILE:          FDefaultTaskManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultTaskManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_TASK_MANAGER_H__
#define __FOCUS_DEFAULT_TASK_MANAGER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FManager;
class FSession;
class FMsgQueue;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultTaskManager : public FTaskManager
{
   public:
      FDefaultTaskManager(FManager& manager);
      virtual ~FDefaultTaskManager();

      virtual FTask::Result executeTasks();
      virtual FTask* getExecutingTask()
      {
         return _executingTask;
      }
      virtual unsigned int getTaskExecutionCount() const
      {
         return _taskExecutionCount;
      }

      virtual bool hasTasks() const
      {
         return !_taskQueue.empty();
      }
      virtual void clearTasks();
      virtual void addTask(FTask* task);
      virtual bool configureTasks(FSession& session);

   protected:
      FManager& _manager;

      //queue for tasks to be executed during a session
      FTaskQueue _taskQueue;
      FTask* _executingTask;
      unsigned int _taskExecutionCount;

   private:
      FDefaultTaskManager(const FDefaultTaskManager&);
      FDefaultTaskManager& operator=(const FDefaultTaskManager&);
};


}

#endif
