/* ***************************************************************************************
* FILE:          FDefaultTaskFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultTaskFactory.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_TASK_FACTORY_H__
#define __FOCUS_DEFAULT_TASK_FACTORY_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FManager;
class FTaskManager;
class FSession;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultTaskFactory : public FTaskFactory
{
   public:
      FDefaultTaskFactory(FManager& manager) : _manager(manager) {}
      virtual ~FDefaultTaskFactory() {}

      virtual bool configureTasks(FTaskManager& taskManager, FSession& session);

   protected:
      //////////////////////////////////////////////////////////////////////////////////////////////
      virtual bool configureNewSessionTasks(FTaskManager& taskManager, FSession& session);
      virtual bool configureCollectingTasks(FTaskManager& taskManager, FSession& session);
      virtual bool configureRefreshingTasks(FTaskManager& taskManager, FSession& session);
      virtual bool configureProcessingTasks(FTaskManager& taskManager, FSession& session);
      virtual bool configurePublishingTasks(FTaskManager& taskManager, FSession& session);
      virtual bool configureFinishedSessionTasks(FTaskManager& taskManager, FSession& session);

      //////////////////////////////////////////////////////////////////////////////////////////////
      virtual FTask* createCourierInfoCollector(FSession& session);
      virtual FTask* createCourierInfoPublisher(FSession& session);
      virtual FTask* createIpcOtherAppsInfoCollector(FSession& session);
      virtual FTask* createIpcOtherAppsStatePublisher(FSession& session);
      virtual FTask* createIpcCrtAppInfoPublisher(FSession& session);
      virtual FTask* createInputMsgProcessor(FSession& session);
      virtual FTask* createAvgBuilder(FSession& session);
      virtual FTask* createAvg2FocusInfoUpdater(FSession& session);
      virtual FTask* createCrtAppState2SessionUpdater(FSession& session);
      virtual FTask* createSession2CrtAppStateUpdater(FSession& session);
      virtual FTask* createSlaveAppUpdater(FSession& session);

      FManager& _manager;

   private:
      FDefaultTaskFactory(const FDefaultTaskFactory&);
      FDefaultTaskFactory& operator=(const FDefaultTaskFactory&);
};


}

#endif
