/* ***************************************************************************************
* FILE:          FDefaultTaskFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultTaskFactory.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultTaskFactory.h"
#include "Focus/FSession.h"
#include "FDefaultAvgBuilder.h"
#include "FDefaultCrtAppExchange.h"
#include "FDefaultInputMsgProcessor.h"
#include "FDefaultOtherAppsExchange.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultTaskFactory.cpp.trc.h"
#endif

namespace Focus {

//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureTasks(FTaskManager& taskManager, FSession& session)
{
   switch (session.getStatus())
   {
      case FSession::New:
         return configureNewSessionTasks(taskManager, session);

      case FSession::Collecting:
         return configureCollectingTasks(taskManager, session);

      case FSession::Refreshing:
         return configureRefreshingTasks(taskManager, session);

      case FSession::Processing:
         return configureProcessingTasks(taskManager, session);

      case FSession::Publishing:
         return configurePublishingTasks(taskManager, session);

      case FSession::Finished:
         return configureFinishedSessionTasks(taskManager, session);

      default:
         return false;
   }
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureNewSessionTasks(FTaskManager& taskManager, FSession& session)
{
   (void)taskManager;
   (void)session;
   return true;
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createCourierInfoCollector(FSession&)
{
   return FOCUS_NEW(FDefaultCourierInfoCollector)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createCourierInfoPublisher(FSession&)
{
   return FOCUS_NEW(FDefaultCourierInfoPublisher)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createIpcOtherAppsInfoCollector(FSession&)
{
   return FOCUS_NEW(FDefaultIpcOtherAppsInfoCollector)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createIpcOtherAppsStatePublisher(FSession&)
{
   return FOCUS_NEW(FDefaultIpcOtherAppsStatePublisher)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createIpcCrtAppInfoPublisher(FSession&)
{
   return FOCUS_NEW(FDefaultIpcCrtAppInfoPublisher)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createInputMsgProcessor(FSession&)
{
   return FOCUS_NEW(FDefaultInputMsgProcessor)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createAvgBuilder(FSession&)
{
   return FOCUS_NEW(FDefaultAvgBuilder)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createAvg2FocusInfoUpdater(FSession&)
{
   return FOCUS_NEW(FAvg2FocusInfoUpdater)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createCrtAppState2SessionUpdater(FSession&)
{
   return FOCUS_NEW(FDefaultCrtAppState2SessionUpdater)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createSession2CrtAppStateUpdater(FSession&)
{
   return FOCUS_NEW(FDefaultSession2CrtAppStateUpdater)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
FTask* FDefaultTaskFactory::createSlaveAppUpdater(FSession&)
{
   return FOCUS_NEW(FDefaultSlaveAppUpdater)(_manager);
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureCollectingTasks(FTaskManager& taskManager, FSession& session)
{
   switch (session.getMode())
   {
      case FSession::Master:
      {
         taskManager.addTask(createCourierInfoCollector(session));
         taskManager.addTask(createCrtAppState2SessionUpdater(session));
         taskManager.addTask(createIpcOtherAppsInfoCollector(session));
         break;
      }

      case FSession::QueryingSlave:
      {
         taskManager.addTask(createCourierInfoCollector(session));
         taskManager.addTask(createCrtAppState2SessionUpdater(session));
         break;
      }

      case FSession::UpdatingSlave:
      {
         taskManager.addTask(createCourierInfoCollector(session));
         //don't add this task because the state will be overwritten (no merging currently)
         //taskManager.addTask(createCrtAppState2SessionUpdater(session));
         break;
      }

      default:
         break;
   }

   return true;
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureRefreshingTasks(FTaskManager& taskManager, FSession& session)
{
   switch (session.getMode())
   {
      case FSession::Master:
      {
         taskManager.addTask(createAvg2FocusInfoUpdater(session));
         taskManager.addTask(createCourierInfoCollector(session));
         //taskManager.addTask(createAvgBuilder(session));
         //taskManager.addTask(createInputMsgProcessor(session));
         //taskManager.addTask(createAvg2FocusInfoUpdater(session));
         break;
      }

      case FSession::QueryingSlave:
      case FSession::UpdatingSlave:
      {
         break;
      }

      default:
         break;
   }

   return true;
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureProcessingTasks(FTaskManager& taskManager, FSession& session)
{
   switch (session.getMode())
   {
      case FSession::Master:
      {
         taskManager.addTask(createAvgBuilder(session));
         taskManager.addTask(createInputMsgProcessor(session));
         taskManager.addTask(createAvg2FocusInfoUpdater(session));
         break;
      }

      case FSession::QueryingSlave:
      case FSession::UpdatingSlave:
      {
         break;
      }

      default:
         break;
   }

   return true;
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configurePublishingTasks(FTaskManager& taskManager, FSession& session)
{
   switch (session.getMode())
   {
      case FSession::Master:
      {
         taskManager.addTask(createSession2CrtAppStateUpdater(session));
         taskManager.addTask(createCourierInfoPublisher(session));
         taskManager.addTask(createIpcOtherAppsStatePublisher(session));
         break;
      }

      case FSession::QueryingSlave:
      {
         taskManager.addTask(createIpcCrtAppInfoPublisher(session));
         break;
      }

      case FSession::UpdatingSlave:
      {
         taskManager.addTask(createSession2CrtAppStateUpdater(session));
         taskManager.addTask(createSlaveAppUpdater(session));
         taskManager.addTask(createCourierInfoPublisher(session));
         break;
      }

      default:
         break;
   }

   return true;
}


//////////////////////////////////////////////////////////////////////////////////////////////
bool FDefaultTaskFactory::configureFinishedSessionTasks(FTaskManager& taskManager, FSession& session)
{
   (void)taskManager;
   (void)session;
   return true;
}


}
