/* ***************************************************************************************
* FILE:          FDefaultSessionManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultSessionManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_SESSION_MANAGER_H__
#define __FOCUS_DEFAULT_SESSION_MANAGER_H__

#include <set>

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FManagerConfig.h"
#include "Focus/FSession.h"

namespace Focus {
class FManager;
class FDefaultSessionManager : public FSessionManager
{
   public:
      FDefaultSessionManager(FManager& manager);
      virtual ~FDefaultSessionManager();

      virtual FSession* getSession()
      {
         return _session;
      }

      virtual void updateSession();
      virtual bool beginSession(FSession::Mode mode);
      virtual void endSession();
      virtual void abortSession();

      virtual bool isSessionSuspended();
      virtual void requestSessionSuspend();
      virtual void clearSessionSuspend();

      virtual bool onMessage(const FMessage& msg);

   protected:
      /* Session state is changed only when there are no queued tasks. Returns true if the state was changed, false otherwise. */
      bool changeSessionState();

      FManager& _manager;
      FSession* _session;

   private:
      FDefaultSessionManager(const FDefaultSessionManager&);
      FDefaultSessionManager& operator=(const FDefaultSessionManager&);
};


}

#endif
