/* ***************************************************************************************
* FILE:          FDefaultRotaryController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultRotaryController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_ROTARY_CONTROLLER_H__
#define __FOCUS_DEFAULT_ROTARY_CONTROLLER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FController.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class FGroup;
class FSession;

/**************************************************************************/
/* ROTARY CONTROLLER                                                      */
/* Handles the rotary encoder related messages.                           */
/**************************************************************************/
class FDefaultRotaryController : public FController
{
   public:
      FDefaultRotaryController(FManager& manager) : _manager(manager) {}
      virtual ~FDefaultRotaryController() {}

      virtual bool onMessage(FSession& session, FGroup& group, const FMessage& msg);

   protected:
      /* Moves the focus with the specified steps (positive or negative). */
      bool moveFocus(FSession& session, FGroup& group, int steps);

      FManager& _manager;

   private:
      FDefaultRotaryController(const FDefaultRotaryController&);
      FDefaultRotaryController& operator=(const FDefaultRotaryController&);
};


}
#endif
