/* ***************************************************************************************
* FILE:          FDefaultRotaryController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultRotaryController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_REQ_HANDLER_H__
#define __FOCUS_DEFAULT_REQ_HANDLER_H__


/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FController.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class FGroup;
class FSession;

/**************************************************************************/
/* Request CONTROLLER                                                     */
/**************************************************************************/
class FDefaultReqController : public FController
{
   public:
      FDefaultReqController(FManager& manager) : _manager(manager) {}

      virtual bool onMessage(FSession& session, FGroup& group, const FMessage& msg);

   protected:
      Focus::FManager& _manager;

   private:
      FDefaultReqController(const FDefaultReqController&);
      FDefaultReqController& operator=(const FDefaultReqController&);
};


}
#endif
