/* ***************************************************************************************
* FILE:          FDefaultOtherAppsExchange.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultOtherAppsExchange.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultOtherAppsExchange.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FSession.h"
#include "Focus/FStateInfo.h"
#include "Focus/FConfigInfo.h"
#include "Focus/FController.h"
#include "Focus/FIpc.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultOtherAppsExchange.cpp.trc.h"
#endif

namespace Focus {

FTask::Result FDefaultIpcCrtAppInfoPublisher::update(FSession& session)
{
   FAppConfigSharedPtr appConfig = session.getCurrentAppConfig();
   FAppStateSharedPtr appState = session.StateInfo.get(_manager.getCurrentAppId());
   if (_manager.getIpcManager() != NULL)
   {
      _manager.getIpcManager()->sendCurrentAppInfo(appConfig, appState);
   }
   return FTask::Completed;
}


FTask::Result FDefaultIpcOtherAppsInfoCollector::update(FSession& session)
{
   (void)session;
   if (_manager.getIpcManager() != NULL)
   {
      //if an occured during previous send attempt don't try it again
      if (_error)
      {
         return FTask::Error;
      }

      //if request was not sent yet, do it
      if (!_requestSent)
      {
         if (_manager.getIpcManager()->sendOtherAppsInfoRequest())
         {
            _requestSent = true;
         }
         //send request failed
         else
         {
            ETG_TRACE_ERR_THR(("FDefaultIpcOtherAppsInfoCollector::update() sendOtherAppsInfoRequest failed!"));
            _error = true;
            return FTask::Error;
         }
      }

      if (_manager.getIpcManager()->isOtherAppsInfoRequestInProgress())
      {
         return FTask::Suspended;
      }
   }

   return FTask::Completed;
}


FTask::Result FDefaultIpcOtherAppsStatePublisher::update(FSession& session)
{
   if (_manager.getIpcManager() != NULL)
   {
      for (size_t i = 0; i < session.StateInfo.count(); ++i)
      {
         FAppStateSharedPtr appState = session.StateInfo.getAt(i);
         if ((!appState.PointsToNull()) && (appState->getId() != _manager.getCurrentAppId()))
         {
            _manager.getIpcManager()->sendOtherAppState(appState);
         }
      }
   }
   return FTask::Completed;
}


FTask::Result FDefaultSlaveAppUpdater::execute()
{
   ETG_TRACE_USR1_THR(("FDefaultSlaveAppUpdater::execute app=%d", _manager.getCurrentAppId()));

   FAppStateSharedPtr appState = _manager.getCurrentAppState();
   if ((!appState.PointsToNull())
         && (appState->CurrentFocusInfo.ViewId != Constants::InvalidViewId)
         && (appState->CurrentFocusInfo.WidgetId != Constants::InvalidId))
   {
      _manager.setFocusVisible(true);
   }
   else
   {
      _manager.setFocusVisible(false);
   }

   return FTask::Completed;
}


}
