/* ***************************************************************************************
* FILE:          FDefaultJoystickController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultJoystickController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_JOYSTICK_CONTROLLER_H__
#define __FOCUS_DEFAULT_JOYSTICK_CONTROLLER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FController.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class FGroup;
class FWidget;
class FSession;
class FJoystickSearchAreaAdjuster;

/**************************************************************************/
/* ROTARY CONTROLLER                                                      */
/* Handles the joystick related messages.                                 */
/**************************************************************************/
class FDefaultJoystickController : public FController
{
   public:
      FDefaultJoystickController(FManager& manager) : _manager(manager) {}
      virtual ~FDefaultJoystickController() {}

      virtual bool onMessage(FSession& session, FGroup& group, const FMessage& msg);

   protected:
      /* Moves the focus in the specified direction. */
      bool moveFocus(FSession& session, FGroup& group, hmibase::FocusDirectionEnum direction);
      FWidget* tryGetNewFocus(FSession& session, FGroup& group, hmibase::FocusDirectionEnum direction,
                              FWidget& originWidget, const FJoystickSearchAreaAdjuster& searchAreaAdjuster);

      FManager& _manager;

   private:
      FDefaultJoystickController(const FDefaultJoystickController&);
      FDefaultJoystickController& operator=(const FDefaultJoystickController&);
};


}
#endif
